local t = Def.ActorFrame {};

local function Update(self)
	local c = self:GetChildren();
	local bps = GAMESTATE:GetSongBPS() or 1
end

local function IsVisible()
	local r = Screen.String("HeaderText");
	return string.len(r) > 0 and true or false
end

t[#t+1] = Def.Quad {
	InitCommand=cmd(vertalign,top;zoomto,SCREEN_WIDTH+1,50;diffuse,color("#00000099"));
};

t[#t+1] = Def.Quad {
	InitCommand=cmd(zoomto,SCREEN_WIDTH+1,02;y,50;diffuse,color("#777777"));
};

t[#t+1] = LoadFont("Common Bold") .. {
	Name="HeaderShadow";
	Text=Screen.String("HeaderText");
	InitCommand=cmd(x,-SCREEN_CENTER_X+26;y,28;zoom,1;horizalign,left;maxwidth,200);
	OnCommand=cmd(visible,IsVisible();skewx,-0.125;diffuse,BoostColor(color("#ffffff00"),0.375););
	UpdateScreenHeaderMessageCommand=function(self,param)
		self:settext(param.Header);
	end;
};

t[#t+1] = Def.Quad {
	Name="Underline";
	InitCommand=cmd(x,-SCREEN_CENTER_X+24-4;y,40;horizalign,left);
	OnCommand=cmd(stoptweening;diffuse,color("#ffffff");shadowlength,2;shadowcolor,BoostColor(color("#ffffff33"),0.25);linear,0.25;zoomtowidth,210;fadeleft,8/192;faderight,0.8
		visible,string.len( Screen.String("HeaderText") ) > 0 );
};

t[#t+1] = LoadFont("Common Bold") .. {
	Name="HeaderText";
	Text=Screen.String("HeaderText");
	InitCommand=cmd(x,-SCREEN_CENTER_X+24;y,26;zoom,0.8;horizalign,left;maxwidth,250);
	OnCommand=cmd(visible,IsVisible();diffuse,color("#ffffff"););
	UpdateScreenHeaderMessageCommand=function(self,param)
		self:settext(param.Header);
	end;
};

t.BeginCommand=function(self)
	self:SetUpdateFunction( Update );
end

return t
